@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('role.list_title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="{{ route('user_role.index') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control"
												placeholder="{{ __('role.search') }}" required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th>{{ __('role.th_name') }}</th>
													<th>{{ __('role.th_users') }}</th>
													<th>{{ __('role.th_created_at') }}</th>
													<th class="fixed-width-td">{{ __('role.th_action') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($roles as $user_role)
												<tr>
													<td class="align-middle">{{ $user_role->name }}</td>
													<td class="align-middle">{{ $user_role->users_count }}</td>
													<td class="align-middle">{{ format_date($user_role->created_at) }}
													</td>
													<td>
														@if($user_role->name != 'Super Admin')
														<div class="d-flex">
															<a href="{{ route('user_role.edit', $user_role->id) }}"
																type="button" class="btn btn-warning mr-2"><i
																	class="fa fa-edit"></i> </a>
															<form class="d-inline js-confirm-delete" method="POST"
																action="{{ route('user_role.destroy', $user_role->id) }}">
																{{ csrf_field() }}
																@method('DELETE')
																<button class="btn btn-danger"><i
																		class="fa fa-trash"></i></button>
															</form>
														</div>
														@endif
													</td>
												</tr>
												@endforeach
												@if(count($roles) == 0)
												<tr>
													<td colspan="9">
														<p class="text-center mb-0">{{ __('role.no_record_found') }}</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
											{{ $roles->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection